// To parse this JSON data, do
//
//     final autoPaymentResponseModel = autoPaymentResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:viserpay/data/model/global/charge/charge_model.dart';
import 'package:viserpay/data/model/global/user/user_model.dart';
import 'package:viserpay/data/model/global/userdata/global_user_data.dart';

import '../global/meassage_model.dart';

AutoPaymentResponseModel autoPaymentResponseModelFromJson(String str) => AutoPaymentResponseModel.fromJson(json.decode(str));

String autoPaymentResponseModelToJson(AutoPaymentResponseModel data) => json.encode(data.toJson());

class AutoPaymentResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  AutoPaymentResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory AutoPaymentResponseModel.fromJson(Map<String, dynamic> json) {
    return AutoPaymentResponseModel(
      remark: json["remark"],
      status: json["status"],
      message: json["message"] == null ? null : Message.fromJson(json["message"]),
      data: json["data"] == null ? null : Data.fromJson(json["data"]),
    );
  }

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  List<String>? otpType;
  String? currentBalance;
  GlobalCharge? sendMoneyCharge;
  GlobalCharge? mobileRechargeCharge;
  List<MobileOperatorCategory>? mobileOperators;
  List<UtilityCategory>? utilityCategory;
  List<AutoPaymentPayBill>? autoPaymentPayBillHistoryList;
  List<AutoPaymentHistoryData>? autoPaymentMobileRechargeHistoryList;
  List<AutoPaymentHistoryData>? autoPaymentSendMoney;

  Data({
    this.otpType,
    this.currentBalance,
    this.sendMoneyCharge,
    this.mobileRechargeCharge,
    this.mobileOperators,
    this.utilityCategory,
    this.autoPaymentPayBillHistoryList,
    this.autoPaymentMobileRechargeHistoryList,
    this.autoPaymentSendMoney,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        otpType: json["otp_type"] == null ? [] : List<String>.from(json["otp_type"]!.map((x) => x)),
        currentBalance: json["current_balance"],
        sendMoneyCharge: json["send_money_charge"] == null ? null : GlobalCharge.fromJson(json["send_money_charge"]),
        mobileRechargeCharge: json["mobile_recharge_charge"] == null ? null : GlobalCharge.fromJson(json["mobile_recharge_charge"]),
        mobileOperators: json["mobile_operators"] == null ? [] : List<MobileOperatorCategory>.from(json["mobile_operators"]!.map((x) => MobileOperatorCategory.fromJson(x))),
        utilityCategory: json["utility"] == null ? [] : List<UtilityCategory>.from(json["utility"]!.map((x) => UtilityCategory.fromJson(x))),
        autoPaymentPayBillHistoryList: json["auto_payment_pay_bill"] == null ? [] : List<AutoPaymentPayBill>.from(json["auto_payment_pay_bill"]!.map((x) => AutoPaymentPayBill.fromJson(x))),
        autoPaymentMobileRechargeHistoryList: json["auto_payment_mobile_recharge"] == null ? [] : List<AutoPaymentHistoryData>.from(json["auto_payment_mobile_recharge"]!.map((x) => AutoPaymentHistoryData.fromJson(x))),
        autoPaymentSendMoney: json["auto_payment_send_money"] == null ? [] : List<AutoPaymentHistoryData>.from(json["auto_payment_send_money"]!.map((x) => AutoPaymentHistoryData.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "otp_type": otpType == null ? [] : List<dynamic>.from(otpType!.map((x) => x)),
        "current_balance": currentBalance,
        "send_money_charge": sendMoneyCharge?.toJson(),
        "mobile_recharge_charge": mobileRechargeCharge?.toJson(),
        "mobile_operators": mobileOperators == null ? [] : List<dynamic>.from(mobileOperators!.map((x) => x.toJson())),
        "utility": utilityCategory == null ? [] : List<dynamic>.from(utilityCategory!.map((x) => x.toJson())),
        "auto_payment_pay_bill": autoPaymentPayBillHistoryList == null ? [] : List<dynamic>.from(autoPaymentPayBillHistoryList!.map((x) => x.toJson())),
        "auto_payment_mobile_recharge": autoPaymentMobileRechargeHistoryList == null ? [] : List<dynamic>.from(autoPaymentMobileRechargeHistoryList!.map((x) => x.toJson())),
        "auto_payment_send_money": autoPaymentSendMoney == null ? [] : List<dynamic>.from(autoPaymentSendMoney!.map((x) => x.toJson())),
      };
}

class AutoPaymentPayBill {
  int? id;
  int? userId;
  dynamic receiverId;
  int? utilityId;
  dynamic operatorId;
  List<AutoPaymentPayBillUserDataInfo>? userData;
  String? amount;
  String? paymentType;
  String? paymentDays;
  DateTime? nextPayment;
  int? status;
  String? createdAt;
  String? updatedAt;
  GlobalUser? user;
  UtilityCategory? setupUtilityBill;

  AutoPaymentPayBill({
    this.id,
    this.userId,
    this.receiverId,
    this.utilityId,
    this.operatorId,
    this.userData,
    this.amount,
    this.paymentType,
    this.paymentDays,
    this.nextPayment,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.user,
    this.setupUtilityBill,
  });

  factory AutoPaymentPayBill.fromJson(Map<String, dynamic> json) => AutoPaymentPayBill(
        id: json["id"],
        userId: json["user_id"],
        receiverId: json["receiver_id"],
        utilityId: json["utility_id"],
        operatorId: json["operator_id"],
        userData: json["user_data"] == null ? [] : List<AutoPaymentPayBillUserDataInfo>.from(json["user_data"]!.map((x) => AutoPaymentPayBillUserDataInfo.fromJson(x))),
        amount: json["amount"],
        paymentType: json["payment_type"],
        paymentDays: json["payment_days"],
        nextPayment: json["next_payment"] == null ? null : DateTime.parse(json["next_payment"]),
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        user: json["user"] == null ? null : GlobalUser.fromJson(json["user"]),
        setupUtilityBill: json["setup_utility_bill"] == null ? null : UtilityCategory.fromJson(json["setup_utility_bill"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "receiver_id": receiverId,
        "utility_id": utilityId,
        "operator_id": operatorId,
        "user_data": userData == null ? [] : List<dynamic>.from(userData!.map((x) => x.toJson())),
        "amount": amount,
        "payment_type": paymentType,
        "payment_days": paymentDays,
        "next_payment": "${nextPayment!.year.toString().padLeft(4, '0')}-${nextPayment!.month.toString().padLeft(2, '0')}-${nextPayment!.day.toString().padLeft(2, '0')}",
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "user": user?.toJson(),
        "setup_utility_bill": setupUtilityBill?.toJson(),
      };
}

class AutoPaymentPayBillUserDataInfo {
  String? name;
  String? type;
  dynamic value;

  AutoPaymentPayBillUserDataInfo({
    this.name,
    this.type,
    this.value,
  });

  factory AutoPaymentPayBillUserDataInfo.fromJson(Map<String, dynamic> json) => AutoPaymentPayBillUserDataInfo(
        name: json["name"]?.toString(),
        type: json["type"]?.toString(),
        value: json['value'] != null ? json['value'].toString() : "",
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "type": type,
        "value": value,
      };
}

class MobileOperatorCategory {
  int? id;
  String? name;
  String? image;
  String? status;
  String? createdAt;
  String? updatedAt;
  String? getImage;

  MobileOperatorCategory({
    this.id,
    this.name,
    this.image,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.getImage,
  });

  factory MobileOperatorCategory.fromJson(Map<String, dynamic> json) => MobileOperatorCategory(
        id: json["id"],
        name: json["name"]?.toString(),
        image: json["image"]?.toString(),
        status: json["status"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        getImage: json["get_image"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "image": image,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "get_image": getImage,
      };
}

class UtilityCategory {
  int? id;
  String? name;
  String? fixedCharge;
  String? percentCharge;
  String? autoPayment;
  String? formId;
  String? image;
  String? status;
  String? createdAt;
  String? updatedAt;
  String? getImage;
  GlobalUserDetailsData? form;

  UtilityCategory({
    this.id,
    this.name,
    this.fixedCharge,
    this.percentCharge,
    this.autoPayment,
    this.formId,
    this.image,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.getImage,
    this.form,
  });

  factory UtilityCategory.fromJson(Map<String, dynamic> json) => UtilityCategory(
        id: json["id"],
        name: json["name"]?.toString(),
        fixedCharge: json["fixed_charge"]?.toString(),
        percentCharge: json["percent_charge"]?.toString(),
        autoPayment: json["auto_payment"]?.toString(),
        formId: json["form_id"]?.toString(),
        image: json["image"]?.toString(),
        status: json["status"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        getImage: json["get_image"]?.toString(),
        form: json["form"] == null ? null : GlobalUserDetailsData.fromJson(json["form"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "fixed_charge": fixedCharge,
        "percent_charge": percentCharge,
        "auto_payment": autoPayment,
        "form_id": formId,
        "image": image,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "get_image": getImage,
        "form": form?.toJson(),
      };
}

class AutoPaymentHistoryData {
  int? id;
  int? userId;
  int? receiverId;
  String? utilityId;
  int? operatorId;
  UserData? userData;
  String? amount;
  String? paymentType;
  String? paymentDays;
  DateTime? nextPayment;
  int? status;
  String? createdAt;
  String? updatedAt;
  GlobalUser? user;
  GlobalUser? receiver;

  AutoPaymentHistoryData({
    this.id,
    this.userId,
    this.receiverId,
    this.utilityId,
    this.operatorId,
    this.userData,
    this.amount,
    this.paymentType,
    this.paymentDays,
    this.nextPayment,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.user,
    this.receiver,
  });

  factory AutoPaymentHistoryData.fromJson(Map<String, dynamic> json) => AutoPaymentHistoryData(
        id: json["id"],
        userId: json["user_id"],
        receiverId: json["receiver_id"],
        utilityId: json["utility_id"]?.toString(),
        operatorId: json["operator_id"],
        userData: json["user_data"] == null ? null : UserData.fromJson(json["user_data"]),
        amount: json["amount"]?.toString(),
        paymentType: json["payment_type"]?.toString(),
        paymentDays: json["payment_days"]?.toString(),
        nextPayment: json["next_payment"] == null ? null : DateTime.parse(json["next_payment"]),
        status: json["status"],
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        user: json["user"] == null ? null : GlobalUser.fromJson(json["user"]),
        receiver: json["receiver"] == null ? null : GlobalUser.fromJson(json["receiver"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "receiver_id": receiverId,
        "utility_id": utilityId,
        "operator_id": operatorId,
        "user_data": userData?.toJson(),
        "amount": amount,
        "payment_type": paymentType,
        "payment_days": paymentDays,
        "next_payment": "${nextPayment!.year.toString().padLeft(4, '0')}-${nextPayment!.month.toString().padLeft(2, '0')}-${nextPayment!.day.toString().padLeft(2, '0')}",
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "user": user?.toJson(),
        "receiver": receiver?.toJson(),
      };
}

class UserData {
  String? mobile;

  UserData({
    this.mobile,
  });

  factory UserData.fromJson(Map<String, dynamic> json) => UserData(
        mobile: json["mobile"],
      );

  Map<String, dynamic> toJson() => {
        "mobile": mobile,
      };
}
